/******************************************************************************************
Filename		:  	materialized_views.sql
Release 		:  	STORET c2.0
SIR			:  	1516
Description		:  	Creates the materialized views used to precalculate counts.
Author			:  	Joseph Wilson
Date			: 	July 8, 2003
				8/11/2003 -- moved grants to storetw.sql script -JW
				8/26/2003 -- commented out project MV since they don't work when hints are passed -JW
				8/26/2003 -- added county and county-char materialized views -JW
				01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  	
******************************************************************************************/
SPOOL materialized_views.log

CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_STATE
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 16k next 16k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_geo_state, count(pk_isn)
from fa_REGULAR_result
group by fk_geo_state;

/**
CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_PROJECT
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 16k next 16k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_project, count(RE.pk_isn) 
FROM FA_REGULAR_RESULT RE,REGULAR_RESULT_PROJECT 
WHERE fk_result = re.pk_isn
group by fk_project;


CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_PROJECT_CHAR
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 50k next 50k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_project, fk_char, count(RE.pk_isn) 
FROM FA_REGULAR_RESULT RE,REGULAR_RESULT_PROJECT 
WHERE fk_result = re.pk_isn
group by fk_project, fk_char;
**/

CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_CHAR
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 50k next 50k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_char, count(pk_isn) 
FROM FA_REGULAR_RESULT
group by fk_char;


CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_CHAR_STATE
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 16k next 16k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_char, fk_geo_state, count(pk_isn) 
FROM FA_REGULAR_RESULT
group by fk_char, fk_geo_state;


CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_ALL
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 1k next 1k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT count(pk_isn) count_all
FROM FA_REGULAR_RESULT;


CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_COUNTY
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 16k next 16k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_geo_county, count(pk_isn)
from fa_REGULAR_result
group by fk_geo_county;


CREATE MATERIALIZED VIEW MV_REGULAR_RESULT_CHAR_COUNTY
PCTFREE 0 TABLESPACE STORETDATA
STORAGE (initial 16k next 16k pctincrease 0)
BUILD IMMEDIATE
REFRESH COMPLETE ON DEMAND
ENABLE QUERY REWRITE
AS
SELECT
fk_char, fk_geo_county, count(pk_isn) 
FROM FA_REGULAR_RESULT
group by fk_char, fk_geo_county;


SPOOL OFF
